const electron = require('electron')
// Module to control application life.
const app = electron.app
// Module to create native browser window.
const BrowserWindow = electron.BrowserWindow

const path = require('path')
const url = require('url')

const Menu = electron.Menu;

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow;
let application = {
  isQuiting: false,
  forceQuite: false
};
let tray = null

/* Single Instance Check */
var iShouldQuit = app.makeSingleInstance(function (commandLine, workingDirectory) {
  if (mainWindow) {
    if (mainWindow.isMinimized()) mainWindow.restore();
    mainWindow.show();
    mainWindow.focus();
  }
  return true;
});
console.log(iShouldQuit);
if (iShouldQuit) { app.quit(); return; }


function createWindow() {
  // Create the browser window.
  mainWindow = new BrowserWindow({
    width: 1020,
    height: 640,
    icon: path.join(__dirname, '/icon.png')
  })

  // and load the index.html of the app.
  mainWindow.loadURL(url.format({
    pathname: path.join(__dirname, '/web/index.html'),
    protocol: 'file:',
    slashes: true,
    icon: path.join(__dirname, '/icon.png')
  }))

  // mainWindow.setSkipTaskbar(true);



  var menu = Menu.buildFromTemplate([
    {
      label: 'PT Side Server',
      submenu: [
        { label: 'Quit', accelerator: 'CmdOrCtrl+Q', click: function () { application.forceQuite = true; app.quit(); } }
      ]
    }]);
  if (process.platform === 'darwin') {
    //in mac
    Menu.setApplicationMenu(menu);
  } else {
    Menu.setApplicationMenu(null);
  }



  tray = new electron.Tray((process.platform !== 'darwin') ? path.join(__dirname, '/icon.png') : path.join(__dirname, '/build/mac-tray@2x.png'))
  const contextMenu = Menu.buildFromTemplate([
    {
      label: '显示', click: function () {
        mainWindow.show();
      }
    },
    {
      label: '退出', click: function () {
        application.isQuiting = true;
        app.quit();

      }
    }
  ])

  tray.setToolTip('PT Side Loader 正在运行');
  tray.setContextMenu(contextMenu)
  tray.on('click', function () {
    mainWindow.show();
  })
  tray.on('double-click', function () {
    mainWindow.show();
  })
  // Open the DevTools.
  // mainWindow.webContents.openDevTools()

  // Emitted when the window is closed.
  mainWindow.on('closed', function () {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null
  });

  mainWindow.on('minimize', function (event) {
    event.preventDefault()
    mainWindow.hide();
  });

  mainWindow.on('hide', event => {
    console.log('hide');
    if (process.platform === 'darwin')
      app.dock.hide()
  });

  mainWindow.on('show', event => {
    console.log('show');
    if (process.platform === 'darwin')
      app.dock.show()
  })


  mainWindow.on('close', function (event) {
    console.log(process.platform);

    if (!application.forceQuite) {
      if (!application.isQuiting) {
        event.preventDefault()
        mainWindow.hide();
      }
    }

    return false;
  });




}


// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow)

// Quit when all windows are closed.
app.on('window-all-closed', function () {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== 'darwin') {
    app.quit()
  }
})

app.on('activate', function () {
  // On OS X it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow()
  }
})

//app will prevent mac from shutdown
// window.onbeforeunload = function (e) { return false };

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
